/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.stream;

import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.FcsConnectionManager;
import com.ibm.hwmca.fw.fcs.impl.disc.DiscoveryCenter;
import com.ibm.hwmca.fw.fcs.impl.stream.StreamConstants;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FcsControlClient
implements Runnable,
StreamConstants {
    private static final String TRACE_MASKD = "XFCSFCCD";
    private static final String TRACE_MASKF = "XFCSFCCF";
    private static final String TRACE_MASKT = "XFCSFCCT";
    private MachineId machineId;
    private InetAddress iaddr;
    private String operation;
    private FcsConnection connection;
    private static Object openConnectionsLock = new Object();
    private static Object badConnectionsLock = new Object();
    private static List openConnections = new ArrayList();
    private static Map badConnections = new HashMap();
    private static Map retryMap = new HashMap();
    private static final int MAX_RETRIES = 3;
    private static final int MAX_BLACKLIST = 12;

    public FcsControlClient(InetAddress iaddr, String operation) {
        this.machineId = FcsServer.getFcsServer().getMachineId(iaddr);
        if (this.machineId == null) {
            this.iaddr = iaddr;
            MachineId localId = FcsServer.getFcsServer().getLocalMachineId();
            this.machineId = new MachineId(iaddr.getHostName(), localId.getGroup(), localId.getVersion(), localId.getType(), localId.getFcsVersion(), new InetAddress[]{iaddr}, new boolean[]{true});
        }
        this.operation = operation;
    }

    public FcsControlClient(MachineId machineId, String operation) {
        this.machineId = machineId;
        this.operation = operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        int i;
        boolean doConnect = true;
        MachineId localMachine = FcsServer.getFcsServer().getLocalMachineId();
        for (int i2 = 0; i2 < this.machineId.getNicAddresses().length; ++i2) {
            for (int j = 0; j < localMachine.getNicAddresses().length; ++j) {
                if (this.machineId.getNicAddresses()[i2] == null || localMachine.getNicAddresses()[j] == null) continue;
                if (this.machineId.getNicAddresses()[i2].equals(localMachine.getNicAddresses()[j])) {
                    j = FcsServer.getFcsServer().getLocalMachineId().getNicAddresses().length;
                    i2 = this.machineId.getNicAddresses().length;
                    doConnect = false;
                    continue;
                }
                if (!this.machineId.getNicAddresses()[i2].getHostAddress().startsWith("127.")) continue;
                doConnect = false;
            }
        }
        if (doConnect && FcsServer.getFcsServer().isBlackListed(this.machineId)) {
            doConnect = false;
        }
        if (doConnect) {
            Object i2 = badConnectionsLock;
            synchronized (i2) {
                for (i = 0; i < this.machineId.getNicAddresses().length; ++i) {
                    if (this.machineId.getNicAddresses()[i] == null || !badConnections.containsKey(this.machineId.getNicAddresses()[i])) continue;
                    doConnect = false;
                    i = this.machineId.getNicAddresses().length;
                }
            }
        }
        if (doConnect) {
            Object i2 = openConnectionsLock;
            synchronized (i2) {
                for (i = 0; i < this.machineId.getNicAddresses().length; ++i) {
                    if (this.machineId.getNicAddresses()[i] == null || !openConnections.contains(this.machineId.getNicAddresses()[i])) continue;
                    doConnect = false;
                    i = this.machineId.getNicAddresses().length;
                }
                if (doConnect) {
                    for (i = 0; i < this.machineId.getNicAddresses().length; ++i) {
                        if (this.machineId.getNicAddresses()[i] == null) continue;
                        openConnections.add(this.machineId.getNicAddresses()[i]);
                    }
                }
            }
        }
        if (doConnect) {
            FcsServiceId serviceId = new FcsServiceId("com.ibm.hwmca.fw.fcs.impl.stream.FcsControlServiceToken", 1.0);
            Trace.trace(TRACE_MASKF, "connecting to: " + this.machineId.getNicAddresses()[0]);
            this.connection = FcsConnection.connect(this.machineId, serviceId);
            this.connection.getSocket().setSoTimeout(120000);
            Map outMap = this.buildOutMap();
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(this.connection.getSocket().getOutputStream()));
            oos.flush();
            oos.writeObject(outMap);
            oos.flush();
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(this.connection.getSocket().getInputStream()));
            Map inMap = (Map)ois.readObject();
            retryMap.remove(this.machineId);
            this.handleInMap(inMap);
            Object var9_18 = null;
            try {
                this.connection.getSocket().close();
            }
            catch (Exception e) {
                // empty catch block
            }
            Object object = openConnectionsLock;
            synchronized (object) {
                for (int i3 = 0; i3 < this.machineId.getNicAddresses().length; ++i3) {
                    if (this.machineId.getNicAddresses()[i3] == null) continue;
                    openConnections.remove(this.machineId.getNicAddresses()[i3]);
                }
            }
            {
                catch (FcsException fcse) {
                    this.handleError(fcse);
                    if (this.iaddr == null) {
                        FcsServer.getFcsServer().removeRemoteServiceList(this.machineId);
                    } else {
                        FcsConnectionManager.removeConnectionInformation(this.iaddr);
                    }
                    Object var9_19 = null;
                    try {
                        this.connection.getSocket().close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Object object2 = openConnectionsLock;
                    synchronized (object2) {
                        for (int i3 = 0; i3 < this.machineId.getNicAddresses().length; ++i3) {
                            if (this.machineId.getNicAddresses()[i3] == null) continue;
                            openConnections.remove(this.machineId.getNicAddresses()[i3]);
                        }
                    }
                }
                catch (IOException ioe) {
                    this.handleError(ioe);
                    Object var9_20 = null;
                    try {
                        this.connection.getSocket().close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Object object3 = openConnectionsLock;
                    synchronized (object3) {
                        for (int i3 = 0; i3 < this.machineId.getNicAddresses().length; ++i3) {
                            if (this.machineId.getNicAddresses()[i3] == null) continue;
                            openConnections.remove(this.machineId.getNicAddresses()[i3]);
                        }
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this.handleError(cnfe);
                    Object var9_21 = null;
                    try {
                        this.connection.getSocket().close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Object object4 = openConnectionsLock;
                    synchronized (object4) {
                        for (int i3 = 0; i3 < this.machineId.getNicAddresses().length; ++i3) {
                            if (this.machineId.getNicAddresses()[i3] == null) continue;
                            openConnections.remove(this.machineId.getNicAddresses()[i3]);
                        }
                    }
                }
                catch (RuntimeException re) {
                    Object var9_22 = null;
                    try {
                        this.connection.getSocket().close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    Object object5 = openConnectionsLock;
                    synchronized (object5) {
                        for (int i3 = 0; i3 < this.machineId.getNicAddresses().length; ++i3) {
                            if (this.machineId.getNicAddresses()[i3] == null) continue;
                            openConnections.remove(this.machineId.getNicAddresses()[i3]);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_23 = null;
                try {
                    this.connection.getSocket().close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                Object object6 = openConnectionsLock;
                synchronized (object6) {
                    for (int i3 = 0; i3 < this.machineId.getNicAddresses().length; ++i3) {
                        if (this.machineId.getNicAddresses()[i3] == null) continue;
                        openConnections.remove(this.machineId.getNicAddresses()[i3]);
                    }
                }
                throw throwable;
            }
        }
        if (!this.machineId.equals(FcsServer.getFcsServer().getLocalMachineId())) {
            Trace.trace(TRACE_MASKF, "Opting not to connect to " + this.machineId.getName());
        }
    }

    private Map buildOutMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FcsControlCommand", this.operation);
        if (this.operation.equals("FcsControlCommandDataExchange")) {
            map.put("FcsControlMachineId", FcsServer.getFcsServer().getLocalMachineId());
            map.put("FcsControlServices", FcsServer.getFcsServer().getLocalServices());
            map.put("FcsControlBootTime", FcsServer.getFcsServer().getLocalBootTime());
        } else if (this.operation.equals("FcsControlCommandHorizon")) {
            map.put("FcsControlCommandHorizon", FcsServer.getFcsServer().getMachineList());
        }
        return map;
    }

    private void handleInMap(Map inMap) {
        if (this.operation.equals("FcsControlCommandDataExchange")) {
            this.handleDataExchange(inMap);
        } else if (this.operation.equals("FcsControlCommandHorizon")) {
            this.handleHorizonSearch(inMap);
        }
    }

    private void handleDataExchange(Map inMap) {
        Trace.trace(TRACE_MASKT, "<> FcsControlClient.handleDataExchange()");
        MachineId machineId = (MachineId)inMap.get("FcsControlMachineId");
        Set services = (Set)inMap.get("FcsControlServices");
        Date bootTime = (Date)inMap.get("FcsControlBootTime");
        if (machineId != null && services != null && bootTime != null) {
            InetAddress[] addrs = machineId.getNicAddresses();
            boolean ok = false;
            if (addrs != null) {
                for (int i = 0; i < addrs.length; ++i) {
                    if (addrs[i] == null || addrs[i].getHostAddress().startsWith("127.")) continue;
                    Trace.trace(TRACE_MASKF, "OK address: " + addrs[i].getHostAddress());
                    ok = true;
                    i = addrs.length;
                }
            }
            if (ok) {
                FcsServer.getFcsServer().addRemoteServiceList(machineId, services, bootTime);
                FcsConnectionManager.didHandshake(machineId);
            } else {
                Trace.trace(TRACE_MASKF, "Inbound MachineID did not have a valid address: " + machineId);
            }
        }
    }

    private void handleHorizonSearch(Map inMap) {
        Trace.trace(TRACE_MASKT, "<> FcsControlClient.handleHorizonSearch()");
        Set otherMachines = (Set)inMap.get("FcsControlCommandHorizon");
        Iterator iterator = otherMachines.iterator();
        while (iterator.hasNext()) {
            MachineId nextId = (MachineId)iterator.next();
            DiscoveryCenter.getDiscoveryCenter().foundAddresses(nextId.getNicAddresses(), DiscoveryCenter.fcsInternallyDiscovered);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(Exception e) {
        Object object = badConnectionsLock;
        synchronized (object) {
            for (int j = 0; j < this.machineId.getNicAddresses().length; ++j) {
                if (this.machineId.getNicAddresses()[j] == null) continue;
                Integer i = (Integer)retryMap.get(this.machineId.getNicAddresses()[j]);
                if (i == null) {
                    Trace.trace(TRACE_MASKF, "creating retry entry for " + this.machineId.getName());
                    retryMap.put(this.machineId.getNicAddresses()[j], new Integer(1));
                    continue;
                }
                if (i == 3) {
                    Trace.trace(TRACE_MASKF, "creating blacklist entry for " + this.machineId.getName());
                    badConnections.put(this.machineId.getNicAddresses()[j], new Integer(1));
                    retryMap.remove(this.machineId.getNicAddresses()[j]);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "updating retry entry for " + this.machineId.getName());
                retryMap.put(this.machineId.getNicAddresses()[j], new Integer(i + 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBlacklist() {
        Object object = badConnectionsLock;
        synchronized (object) {
            Integer i;
            InetAddress nextAddr;
            Iterator iterator = ((Map)((HashMap)badConnections).clone()).keySet().iterator();
            while (iterator.hasNext()) {
                nextAddr = (InetAddress)iterator.next();
                i = (Integer)badConnections.get(nextAddr);
                if (i == 12) {
                    Trace.trace(TRACE_MASKF, "removing blacklist entry for: " + nextAddr);
                    badConnections.remove(nextAddr);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "updating blacklist entry for: " + nextAddr);
                badConnections.put(nextAddr, new Integer(i + 1));
            }
            iterator = ((Map)((HashMap)retryMap).clone()).keySet().iterator();
            while (iterator.hasNext()) {
                nextAddr = (InetAddress)iterator.next();
                i = (Integer)retryMap.get(nextAddr);
                if (i == 0) {
                    Trace.trace(TRACE_MASKF, "removing retry entry for: " + nextAddr);
                    retryMap.remove(nextAddr);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "updating retry entry for: " + nextAddr);
                retryMap.put(nextAddr, new Integer(i - 1));
            }
        }
    }
}

